/*
 * Decompiled with CFR 0.152.
 */
package com.uniubi.sdk;

import com.uniubi.sdk.ParamExpander;
import com.uniubi.sdk.StringUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;

public final class EncodingUtils {
    private static final ParamExpander paramExpander = new ParamExpander();

    private EncodingUtils() {
    }

    public static Object encodeCollection(Collection<?> parameters, String collectionFormat) {
        if (parameters == null) {
            return parameters;
        }
        ArrayList<String> stringValues = new ArrayList<String>(parameters.size());
        for (Object parameter : parameters) {
            if (parameter == null) continue;
            stringValues.add(EncodingUtils.encode(parameter));
        }
        if (stringValues.size() < 2 || "multi".equals(collectionFormat)) {
            return stringValues;
        }
        String[] stringArray = stringValues.toArray(new String[0]);
        switch (collectionFormat) {
            default: {
                return StringUtil.join(stringArray, ",");
            }
            case "ssv": {
                return StringUtil.join(stringArray, " ");
            }
            case "tsv": {
                return StringUtil.join(stringArray, "\t");
            }
            case "pipes": 
        }
        return StringUtil.join(stringArray, "|");
    }

    public static String encode(Object parameter) {
        if (parameter == null) {
            return null;
        }
        try {
            return URLEncoder.encode(paramExpander.expand(parameter), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

