package com.ifourthwall.dbm.task.facade;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.dbm.task.dto.*;

import java.util.List;

/**
 * @author: fpc
 * @data: 2019/11/1 18:27
 * @Description:
 */
public interface WorkSheetFacade {

    /**
     * 创建工单
     * @author fpc
     * @date 2019/11/6 16:59
     * @param taskWorksheetInsertWrapDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.lang.Object>
     */
    BaseResponse<Object> createWorksheet(TaskWorksheetInsertWrapDTO taskWorksheetInsertWrapDTO);

    /**
     * 批量创建工单
     * @author fpc
     * @date 2019/11/11 17:58
     * @param worksheetBatchCreate
     * @return com.ifourthwall.common.base.BaseResponse<java.lang.Object>
     */
    BaseResponse<Object> createWorksheetBatch(WorksheetBatchCreateDTO worksheetBatchCreate);

    /**
     * 批量创建计划任务工单
     * @author fpc
     * @date 2019/11/28 18:17
     * @param
     * @return com.ifourthwall.common.base.BaseResponse<java.lang.Object>
     */
    BaseResponse<Object> createPlanTaskWorksheetBatch(WorksheetBatchCreateDTO worksheetBatchCreate);

    /**
     * 删除工单
     * @author fpc
     * @date 2019/11/6 17:19
     * @param worksheetOperateDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.lang.Object>
     */
    BaseResponse<Object> deleteWorksheet(WorksheetOperateDTO worksheetOperateDTO);

    /**
     * 查询临时工单列表(抢单、查询)
     * @author fpc
     * @date 2019/11/1 18:29
     * @param operationTempWorksheetListQueryDTO
     * @return com.ifourthwall.common.base.BaseResponse<com.github.pagehelper.PageInfo<com.ifourthwall.dbm.task.dto.TemporyTaskWorkSheetListDTO>>
     */
    BaseResponse<IFWPageInfo<TemporyTaskWorkSheetListDTO>> getOperationTempTaskWorkSheetList(OperationTempWorksheetListQueryDTO operationTempWorksheetListQueryDTO);


    /**
     * 分页查询临时任务工单
     * @author fpc
     * @date 2020/3/9 14:37
     * @param tempTaskWorksheetQueryDTO
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.common.base.IFWPageInfo<com.ifourthwall.dbm.task.dto.TemporyTaskWorkSheetListDTO>>
     */
    BaseResponse<IFWPageInfo<TemporyTaskWorkSheetListDTO>> getTempTaskWorksheetList(TempTaskWorksheetQueryDTO tempTaskWorksheetQueryDTO);

    /**
     * 统计分析按部门查看临时工单列表
     * @param worksheetStatisticListDTO
     * @return
     */
    BaseResponse<IFWPageInfo<TemporyTaskWorkSheetListDTO>> getStatisticTempWorksheetList(WorksheetStatisticListDTO worksheetStatisticListDTO);

    /**
     * 导出临时任务工单表格
     * @param exportTemporaryWorksheetQueryDTO
     * @return
     */
    BaseResponse<IFWPageInfo<ExportTemporaryWorksheetDTO>> getExportTemporaryWorksheetList(ExportTemporaryWorksheetQueryDTO exportTemporaryWorksheetQueryDTO);

    /**
     * 查询日常任务工单列表
     * @author fpc
     * @date 2019/11/2 15:28
     * @param dailyTaskWorkSheetListQueryDTO
     * @return com.ifourthwall.common.base.BaseResponse<com.github.pagehelper.PageInfo<com.ifourthwall.dbm.task.dto.DailyTaskWorkSheetListDTO>>
     */
    BaseResponse<IFWPageInfo<DailyTaskWorkSheetListDTO>> getDailyTaskWorkSheetList(DailyTaskWorkSheetListQueryDTO dailyTaskWorkSheetListQueryDTO);


    /**
     * 查询日常任务离线工单信息
     * @author fpc
     * @date 2019/11/2 15:28
     * @param queryDailyOfflinePackageDTO
     * @return com.ifourthwall.common.base.BaseResponse<com.github.pagehelper.PageInfo<com.ifourthwall.dbm.task.dto.DailyTaskWorkSheetListDTO>>
     */
    BaseResponse<List<DailyTaskWorkSheetListDTO>> getOfflineDailyTaskWorksheetList(QueryDailyOfflinePackageDTO queryDailyOfflinePackageDTO);

    /**
     * 统计分析按部门查看日常任务列表
     * @param worksheetStatisticListDTO
     * @return
     */
    BaseResponse<IFWPageInfo<DailyTaskWorkSheetListDTO>> getStatisticDailyWorksheetList(WorksheetStatisticListDTO worksheetStatisticListDTO);

    /**
     * 查询导出日常任务工单数据
     * @param exportDailyWorksheetQueryDTO
     * @return
     */
    BaseResponse<IFWPageInfo<DailyTaskWorkSheetListDTO>> getExportDailyWorksheetList(ExportDailyWorksheetQueryDTO exportDailyWorksheetQueryDTO);

    /**
     * 查询该工单可以分享的岗位（Task可以分享的岗位和模版对应分享委派岗位的交集）
     * @author fpc
     * @date 2019/11/6 17:47
     * @param worksheetAssignListQueryDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.task.dto.TaskExecutorInsertDTO>>
     */
    BaseResponse<List<TaskExecutorInsertDTO>> getWorksheetAssignList(WorksheetAssignListQueryDTO worksheetAssignListQueryDTO);

    /**
     * 升级待处理
     * @author fpc
     * @date 2019/11/6 18:27
     * @param worksheetOperateDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.lang.Object>
     */
    BaseResponse<Object> upgradeWorksheet(WorksheetOperateDTO worksheetOperateDTO);

    /**
     * 修改工单标签
     * @author fpc
     * @date 2019/11/7 10:30
     * @param worksheetOperateDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.lang.Object>
     */
    BaseResponse<Object> updateWorksheetLabel(WorksheetOperateDTO worksheetOperateDTO);

    /**
     * 添加物料消耗/金额备注
     * @author fpc
     * @date 2019/11/7 10:31
     * @param worksheetOperateDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.lang.Object>
     */
    BaseResponse<Object> addConsumption(WorksheetOperateDTO worksheetOperateDTO);

    /**
     * 添加反馈
     * @author fpc
     * @date 2019/11/7 11:52
     * @param worksheetOperateDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.lang.Object>
     */
    BaseResponse<Object> addFeedback(WorksheetOperateDTO worksheetOperateDTO);

    /**
     * 添加内容补充
     * @author fpc
     * @date 2019/11/7 17:31
     * @param worksheetOperateDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.lang.Object>
     */
    BaseResponse<Object> addWorksheetContent(WorksheetOperateDTO worksheetOperateDTO);

    /**
     * 完成工单
     * @author fpc
     * @date 2019/11/7 17:32
     * @param worksheetOperateDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.lang.Object>
     */
    BaseResponse<Object> finishWorksheet(WorksheetOperateDTO worksheetOperateDTO);

    /**
     * 分享委派工单
     * @author fpc
     * @date 2019/11/7 17:32
     * @param worksheetOperateDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.lang.Object>
     */
    BaseResponse<Object> shareWorksheet(WorksheetOperateDTO worksheetOperateDTO);

    /**
     * 抢单
     * @author fpc
     * @date 2019/11/7 17:33
     * @param worksheetOperateDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.lang.Object>
     */
    BaseResponse<Object> competeWorksheet(WorksheetOperateDTO worksheetOperateDTO);

    /**
     * 查询临时任务工单详情
     * @author fpc
     * @date 2019/11/8 16:41
     * @param worksheetDetailQueryDTO
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.task.dto.TemporaryTaskWorksheetWrapDTO>
     */
    BaseResponse<TemporaryTaskWorksheetWrapDTO> getTemporaryTaskWorksheetDetail(WorksheetDetailQueryDTO worksheetDetailQueryDTO);

    /**
     * 查询日常任务工单详情
     * @author fpc
     * @date 2019/11/9 13:51
     * @param worksheetDetailQueryDTO
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.task.dto.DailyTaskWorkSheetWrapDTO>
     */
    BaseResponse<DailyTaskWorkSheetWrapDTO> getDailyTaskWorksheetDetail(WorksheetDetailQueryDTO worksheetDetailQueryDTO);

    /**
     * 查询creataBy和scanRouteUuid下的巡视点位详情
     * @author fpc
     * @date 2019/11/9 13:30
     * @param checkPointScanInfoQueryDTO
     * @return java.util.List<com.ifourthwall.dbm.task.bo.WorksheetEventSupperWrapBO>
     */
    BaseResponse<List<WorksheetEventSupperWrapDTO>> checkPointScanInfoBOList(CheckPointScanInfoQueryDTO checkPointScanInfoQueryDTO);

    /**
     * 巡点信息上传
     * @author fpc
     * @date 2019/11/9 18:51
     * @param uploadScanWrapDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.lang.Object>
     */
    BaseResponse<UploadScanResultDTO> uploadScanInfo(UploadScanWrapDTO uploadScanWrapDTO);

    /**
     * 验收工单
     * @author fpc
     * @date 2019/11/11 15:23
     * @param worksheetOperateDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.lang.Object>
     */
    BaseResponse<Object> checkWorksheet(WorksheetOperateDTO worksheetOperateDTO);

    /**
     * 工单提醒
     * @author fpc
     * @date 2019/11/11 15:49
     * @param worksheetOperateDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.lang.Object>
     */
    BaseResponse<Object> remindWorksheet(WorksheetOperateDTO worksheetOperateDTO);

    /**
     * 工单详情中查看该工单的操作权限
     * @author fpc
     * @date 2019/11/20 15:31
     * @param taskOperationQueryDTO
     * @return java.util.List<java.lang.String>
     */
    BaseResponse<List<String>> getWorksheetOperationList(TaskOperationQueryDTO taskOperationQueryDTO);

    /**
     * 功能描述
     * @author fpc
     * @date 2019/12/12 13:38
     * @param worksheetDetailQueryDTO
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.task.dto.CommonWorksheetDetailDTO>
     */
    BaseResponse<CommonWorksheetDetailDTO> getCommonWorksheetDetail(WorksheetDetailQueryDTO worksheetDetailQueryDTO);


    /**
     * seer查询任务工单列表接口
     * @param seerWorksheetQueryDTO
     * @return
     */
    BaseResponse<IFWPageInfo<WorksheetListForSeerDTO>> getWorksheetListForSeer(SeerWorksheetQueryDTO seerWorksheetQueryDTO);

    /**
     * seer 根据asset 查询工单
     * @param worksheetQueryByAssetDTO
     * @return
     */
    BaseResponse<IFWPageInfo<WorksheetListForSeerDTO>> getWorksheetByAssetIdForSeer(WorksheetQueryByAssetDTO worksheetQueryByAssetDTO);

    /**
     * seer查询任务工单列表工单数
     * @param seerWorksheetQueryDTO
     * @return
     */
    BaseResponse<WorksheetCountForSeerDTO> getWorksheetCountForSeer(SeerWorksheetQueryDTO seerWorksheetQueryDTO);

    /**
     * 根据工单id查询工单对应的模版id
     * @author fpc
     * @date 2020/3/12 16:51
     * @param worksheetDetailQueryDTO
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.task.dto.SingleStringOutDTO>
     */
    BaseResponse<SingleStringOutDTO> getTaskTemplateByWorksheetId(WorksheetDetailQueryDTO worksheetDetailQueryDTO);

    /**
     * 根据taskId查询工单列表
     * @author fpc
     * @date 2020/3/12 16:55
     * @param taskWorksheetListQueryDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.task.dto.TaskWorksheetDTO>>
     */
    BaseResponse<List<TaskWorksheetDTO>> getTaskWorksheetListByTaskId(TaskWorksheetListQueryDTO taskWorksheetListQueryDTO);

    /**
     * 查询工单的执行人信息
     * @author fpc
     * @date 2020/3/13 17:28
     * @param worksheetDetailQueryDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.task.dto.WorksheetExecutorDTO>>
     */
    BaseResponse<List<WorksheetExecutorDTO>> getWorksheetExecutor(WorksheetDetailQueryDTO worksheetDetailQueryDTO);

    /**
     * seer根据空间查询工单列表
     * @author fpc
     * @date 2020/3/30 11:36
     * @param worksheetQueryBySpaceDTO
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.common.base.IFWPageInfo<com.ifourthwall.dbm.task.dto.WorksheetListOutlineForSeerDTO>>
     */
    BaseResponse<IFWPageInfo<WorksheetListOutlineForSeerDTO>> queryWorksheetBySpace(WorksheetQueryBySpaceDTO worksheetQueryBySpaceDTO);

    /**
     * 查询各个空间下有没有特殊工单
     * @author fpc
     * @date 2020/3/30 14:19
     * @param spaceSpecialQueryDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.task.dto.SpaceSpecialDTO>>
     */
    BaseResponse<List<SpaceSpecialDTO>> querySpecialBySpace(SpaceSpecialQueryDTO spaceSpecialQueryDTO);

    /**
     * 自动反馈工单
     * @author fpc
     * @date 2020/6/10 11:57
     * @param waitFeedBackQueryDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.lang.Object>
     */
    BaseResponse<Object> autoFeedBckWorksheet(WaitFeedBackQueryDTO waitFeedBackQueryDTO);

}
