package com.ifourthwall.dbm.task.facade;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.dbm.task.dto.CheckpointScanResultDTO;
import com.ifourthwall.dbm.task.dto.QueryScanResultByCheckpointIdDTO;
import com.ifourthwall.dbm.task.dto.WorksheetEventDetailQueryDTO;
import com.ifourthwall.dbm.task.dto.WorksheetEventWrapDTO;

/**
 * @author: fpc
 * @data: 2019/11/6 15:33
 * @Description:
 */
public interface WorkSheetEventFacade {

    /**
     * 创建事件
     * @author fpc
     * @date 2019/11/6 15:42
     * @param worksheetEventWrapDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.lang.Object>
     */
    BaseResponse<Object> createWorksheetEvent(WorksheetEventWrapDTO worksheetEventWrapDTO);

    /**
     * 查看添加事件详情
     * @author fpc
     * @date 2019/11/7 18:07
     * @param worksheetEventDetailQueryDTO
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.task.dto.WorksheetEventWrapDTO>
     */
    BaseResponse<WorksheetEventWrapDTO> getWorksheetEventDetail(WorksheetEventDetailQueryDTO worksheetEventDetailQueryDTO);

    /**
     * 根据checkpointId查询该点巡视信息
     * @param queryScanResultByCheckpointIdDTO
     * @return
     */
    BaseResponse<IFWPageInfo<CheckpointScanResultDTO>> getScanInfoByCheckpoint(QueryScanResultByCheckpointIdDTO queryScanResultByCheckpointIdDTO);
}
