package com.ifourthwall.dbm.task.facade;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.dbm.task.dto.*;

import java.util.List;

/**
 * @author: fpc
 * @data: 2019/10/25 16:43
 * @Description:
 */
public interface TaskTemplateFacade {

    /**
     * 创建任务模版标签
     * @author fpc
     * @date 2019/10/25 16:52
     * @param taskTemplateTagInsertDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.lang.Object>
     */
    BaseResponse<Object> createTaskTemplateTag(TaskTemplateTagInsertDTO taskTemplateTagInsertDTO);

    /**
     * 更新任务模版标签
     * @author fpc
     * @date 2019/10/25 17:00
     * @param taskTemplateTagUpdateDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.lang.Object>
     */
    BaseResponse<Object> updateTaskTemplateTag(TaskTemplateTagUpdateDTO taskTemplateTagUpdateDTO);

    /**
     * 查询任务模版标签详情
     * @author fpc
     * @date 2020/1/11 11:04
     * @param taskTemplateTagDetailQueryDTO
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.task.dto.TaskTemplateTagDTO>
     */
    BaseResponse<TaskTemplateTagDTO> queryTaskTemplateTagDetail(TaskTemplateTagDetailQueryDTO taskTemplateTagDetailQueryDTO);

    /**
     * 查询任务模版标签列表
     * @author fpc
     * @date 2019/10/25 17:04
     * @param taskTemplateTagQueryDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.task.dto.TaskTemplateTagDTO>>
     */
    BaseResponse<List<TaskTemplateTagDTO>> getTaskTemplateTagList(TaskTemplateTagQueryDTO taskTemplateTagQueryDTO);


    /**
     * 根据任务模版查询标签列表
     * @author fpc
     * @date 2019/10/25 17:04
     * @param taskTemplateTagQueryDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.task.dto.TaskTemplateTagDTO>>
     */
    BaseResponse<List<TaskTemplateTagDTO>> getTaskTemplateTagListByTaskTemplateId(TaskTemplateTagQueryDTO taskTemplateTagQueryDTO);

    /**
     * 创建任务模版
     * @author fpc
     * @date 2019/10/25 17:05
     * @param taskTemplateInsertWrapDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.lang.Object>
     */
    BaseResponse<Object> createTaskTemplate(TaskTemplateInsertWrapDTO taskTemplateInsertWrapDTO);

    /**
     * 获取任务模版列表接口
     * @author fpc
     * @date 2019/10/25 17:06
     * @param taskTemplateListByOperationQueryDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<java.lang.Object>>
     */
    BaseResponse<List<TaskTemplateDTO>> getTaskTemplateList(TaskTemplateListByOperationQueryDTO taskTemplateListByOperationQueryDTO);

    /**
     * 查询所有任务模版
     * @author fpc
     * @date 2019/11/8 10:17
     * @param taskTemplateListQueryDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.task.dto.TaskTemplateDTO>>
     */
    BaseResponse<List<TaskTemplateDTO>> getAllTaskTemplateList(TaskTemplateListQueryDTO taskTemplateListQueryDTO);

    /**
     * 查询任务模版详情
     * @author fpc
     * @date 2019/10/25 17:22
     * @param taskTemplateWarpQueryDTO
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.task.dto.TaskTemplateWrapDTO>
     */
    BaseResponse<TaskTemplateWrapDTO> getTaskTemplateDetail(TaskTemplateWarpQueryDTO taskTemplateWarpQueryDTO);

    /**
     * 删除任务模版
     * @author fpc
     * @date 2019/10/25 17:22
     * @param taskTemplateWarpQueryDTO
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.task.dto.TaskTemplateWrapDTO>
     */
    BaseResponse<Object> deleteTaskTemplate(TaskTemplateWarpQueryDTO taskTemplateWarpQueryDTO);

    /**
     * 更新任务模版
     * @author fpc
     * @date 2019/10/25 17:35
     * @param taskTemplateUpdateWrapDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.lang.Object>
     */
    BaseResponse<Object> updateTaskTemplate(TaskTemplateUpdateWrapDTO taskTemplateUpdateWrapDTO);

    /**
     * 查询某一模版下，某一主语岗位Id对应的operationId可以对那些宾语岗位Id进行相关操作
     * @author fpc
     * @date 2019/11/11 18:42
     * @param taskTemplatePermissionRelationQueryDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<java.lang.String>>
     */
    BaseResponse<List<String>> getTaskTemplatePermissionByOperationId(TaskTemplatePermissionRelationQueryDTO taskTemplatePermissionRelationQueryDTO);


    /**
     * 查询某一模版下，某一主语岗位Id对应的operationId可以对那些宾语岗位Id进行相关操作
     * @author fpc
     * @date 2019/11/11 18:42
     * @param objectPositionQueryDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<java.lang.String>>
     */
    BaseResponse<List<String>> getObjectPositionIdByOperationId(ObjectPositionQueryDTO objectPositionQueryDTO);

    /**
     * 查询模版关系列表
     * @author fpc
     * @date 2020/4/16 13:40
     * @param taskTemplateQueryByIdListDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.task.dto.TaskTemplatePermissionRelationDTO>>
     */
    BaseResponse<List<TaskTemplatePermissionRelationDTO>> selectTaskTemplateListByOperation(TaskTemplateQueryByIdListDTO taskTemplateQueryByIdListDTO);
}
