package com.ifourthwall.dbm.task.facade;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.dbm.task.dto.*;

import java.util.List;

/**
 * @Author: hao.dai
 * @Date: 2019/10/18 17:43
 * @Description:
 */
public interface TaskFacade {

    /**
     * 创建任务
     * @author fpc
     * @date 2019/10/31 11:06
     * @param taskWrapInsertDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.lang.Object>
     */
    BaseResponse<SingleStringOutDTO> createTask(TaskWrapInsertDTO taskWrapInsertDTO);

    /**
     * 操作任务 删除 失效 有效
     * @author fpc
     * @date 2019/10/31 11:20
     * @param taskOperateDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.lang.Object>
     */
    BaseResponse<Object> operateTask(TaskOperateDTO taskOperateDTO);

    /**
     * 查询任务对应操作权限Id可执行人员岗位列表（通过任务模版查）
     * @author fpc
     * @date 2019/10/31 17:11
     * @param taskTemplatePermissionExecutorQueryDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<java.lang.String>>
     */
    BaseResponse<List<String>> getTaskExecutor(TaskTemplatePermissionExecutorQueryDTO taskTemplatePermissionExecutorQueryDTO);

    /**
     * 更新任务信息（实则是逻辑删除之前的任务信息，然后再创建新的任务 ，针对计划任务修改用）
     * @author fpc
     * @date 2019/11/1 10:24
     * @param taskWrapInsertDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.lang.Object>
     */
    BaseResponse<Object> updateTask(TaskWrapInsertDTO taskWrapInsertDTO);

    /**
     * 获取计划任务服务提供方
     * @author fpc
     * @date 2019/11/1 10:29
     * @param serviceSupplierListQueryDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.task.dto.ServiceSupplierDTO>>
     */
    BaseResponse<List<ServiceSupplierDTO>> getServiceSupplierList(ServiceSupplierListQueryDTO serviceSupplierListQueryDTO);

    /**
     * 获取任务详情
     * @author fpc
     * @date 2019/11/1 11:59
     * @param taskDetailQueryDTO
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.task.dto.TaskWrapDetailDTO>
     */
    BaseResponse<TaskWrapDetailDTO> getTaskDetail(TaskDetailQueryDTO taskDetailQueryDTO);

    /**
     * 根据checkpoint查询对应的task信息
     * @author fpc
     * @date 2019/11/26 14:58
     * @param worksheetScanQueryDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.task.dto.TaskWithWorksheetDTO>>
     */
    BaseResponse<List<TaskWithWorksheetWithCheckpointDTO>> getTaskListByCheckpointId(WorksheetScanQueryDTO worksheetScanQueryDTO);

    /**
     * 分页查询任务相关信息
     * @author fpc
     * @date 2019/12/3 11:51
     * @param taskListPageQueryDTO
     * @return com.ifourthwall.common.base.BaseResponse<com.github.pagehelper.PageInfo<com.ifourthwall.dbm.task.dto.TaskListDTO>>
     */
    BaseResponse<IFWPageInfo<TaskListDTO>> getTaskList(TaskListPageQueryDTO taskListPageQueryDTO);

    /**
     * 删除checkPointId
     * @author fpc
     * @date 2019/12/11 15:04
     * @param checkPointQueryDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.lang.Object>
     */
    BaseResponse<Object> deleteCheckPointId(CheckPointQueryDTO checkPointQueryDTO);

    /**
     * 根据userId查询该user未完成的工单
     * @author fpc
     * @date 2020/4/9 18:09
     * @param queryWorksheetByUserDTO
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.task.dto.WorksheetByUserDTO>
     */
    BaseResponse<WorksheetByUserDTO> queryWorksheetByUser(QueryWorksheetByUserDTO queryWorksheetByUserDTO);

    /**
     * 根据checkpointId查询是否有任务绑定
     * @author fpc
     * @date 2020/4/20 10:19
     * @param queryCheckpointRelationByIdDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.task.dto.TaskCheckPointRelationInsertDTO>>
     */
    BaseResponse<List<String>> selectByCheckpointId(QueryCheckpointRelationByIdDTO queryCheckpointRelationByIdDTO);

    /**
     * 根据taskId查询对应工单信息
     * @author fpc
     * @date 2020/4/28 15:13
     * @param queryWorksheetByTaskIdDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.task.dto.TaskWorksheetDTO>>
     */
    BaseResponse<List<TaskWorksheetDTO>> queryWorksheetByTaskId(QueryWorksheetByTaskIdDTO queryWorksheetByTaskIdDTO);
}
