package com.ifourthwall.dbm.task.facade;

import com.fasterxml.jackson.databind.ser.Serializers;
import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.dbm.task.dto.*;

import java.util.List;

/**
 * @author: fpc
 * @data: 2019/11/12 18:16
 * @Description:
 */
public interface StatisticsFacade {

    /**
     * 查询某个人某段时间对应工单数量统计
     * @author fpc
     * @date 2020/1/4 18:28
     * @param singleWorksheetSummeryQueryDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.task.dto.WorksheetAndNumDTO>>
     */
    BaseResponse<List<WorksheetAndNumDTO>> getAllWorksheetNum(SingleWorksheetSummeryQueryDTO singleWorksheetSummeryQueryDTO);

    /**
     * 查询点位巡视概要
     * @author fpc
     * @date 2019/11/12 18:19
     * @param patrolRecordByMonthQueryDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.task.dto.PatrolRecordByMonthDTO>>
     */
    BaseResponse<List<PatrolRecordByMonthDTO>> getPatrolRecordByMonth(PatrolRecordByMonthQueryDTO patrolRecordByMonthQueryDTO);

    /**
     * 查询点位巡视具体信息
     * @author fpc
     * @date 2019/11/12 18:21
     * @param patrolRecordByMonthQueryDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.task.dto.PatrolCheckpointRecordByMonthDTO>>
     */
    BaseResponse<List<PatrolCheckpointRecordByMonthDTO>> getPatrolCheckpointRecordByMonth(PatrolRecordByMonthQueryDTO patrolRecordByMonthQueryDTO);

    /**
     * 通过checkpointId查询巡视事件信息
     * @author fpc
     * @date 2019/11/12 18:23
     * @param worksheetListByCheckpointQueryDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.task.dto.WorksheetEventSupperWrapDTO>>
     */
    BaseResponse<List<WorksheetEventSupperWrapDTO>> getWorksheetListByCheckpointId(WorksheetListByCheckpointQueryDTO worksheetListByCheckpointQueryDTO);

    /**
     * 查询详细的工单统计信息（临时工单，日常工单，计划工单，完成时间）
     * @author fpc
     * @date 2019/11/14 13:41
     * @param taskAndReportSummeryQueryDTO
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.task.dto.TaskSummeryDTO>
     */
    BaseResponse<TaskSummeryDTO> getTaskSummery(TaskAndReportSummeryQueryDTO taskAndReportSummeryQueryDTO);

    /**
     * 查询报事统计信息
     * @author fpc
     * @date 2019/11/14 13:44
     * @param reportSummeryQueryDTO
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.task.dto.ReportSummeryDTO>
     */
    BaseResponse<ReportSummeryDTO> getReportSummery(ReportSummeryQueryDTO reportSummeryQueryDTO);

    /**
     * 根据岗位分组，每个岗位完成有多少工单
     * @author fpc
     * @date 2019/11/14 14:02
     * @param taskAndReportSummeryQueryDTO
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.task.dto.WorksheetSummeryDeptDTO>
     */
    BaseResponse<List<WorksheetSummeryDeptDTO>> getTaskSummeryByDept(TaskAndReportSummeryQueryDTO taskAndReportSummeryQueryDTO);

    /**
     * 柱状图统计数据信息（每周 每月 每年 完成工单数统计信息）
     * @author fpc
     * @date 2019/11/14 14:10
     * @param worksheetSummeryListQueryDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.task.dto.WorksheetSummeryListDTO>>
     */
    BaseResponse<List<WorksheetSummeryListDTO>> getWorksheetSummeryList(WorksheetSummeryListQueryDTO worksheetSummeryListQueryDTO);

    /**
     * seer 查询project下工单数量
     * @param queryWorksheetNumByProjectDTO
     * @return
     */
    BaseResponse<List<WorksheetNumByProjectDTO>> getSeerWorksheetNumByProject(QueryWorksheetNumByProjectDTO queryWorksheetNumByProjectDTO);

    /**
     * 根据checkpointIdList 查询点位巡视概要信息
     * @param checkpointScanOutlineQueryDTO
     * @return
     */
    BaseResponse<List<CheckpointScanOutlineDTO>> getScanOutlineByCheckpointId(CheckpointScanOutlineQueryDTO checkpointScanOutlineQueryDTO);

    /**
     * 查询工单列表For Seer 根据部门柱状图
     * @param worksheetListChartByDeptQueryDTO
     * @return
     */
    BaseResponse<List<WorksheetListForSeerDTO>> getWorksheetListForSeerChartByDept(WorksheetListChartByDeptQueryDTO worksheetListChartByDeptQueryDTO);

    /**
     * 任务工单标签完成统计
     * @author fpc
     * @date 2020/3/2 16:01
     * @param tagStatisticQueryDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.task.dto.TagStatisticResultDTO>>
     */
    BaseResponse<List<TagStatisticResultDTO>> getTagStatistic(TagStatisticQueryDTO tagStatisticQueryDTO);

    /**
     * 根据assetId集合查询信息
     * @author fpc
     * @date 2020/3/27 17:40
     * @param faultAssetQueryDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.task.dto.AssetCheckRecordDTO>>
     */
    BaseResponse<List<AssetCheckRecordDTO>> getAssetListByAssetId(FaultAssetQueryDTO faultAssetQueryDTO);


    /**
     * 根据资产id查询资产列表
     * @author fpc
     * @date 2020/4/26 19:46
     * @param assetWorksheetQueryDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.task.dto.AssetWorksheetDTO>>
     */
    BaseResponse<IFWPageInfo<AssetWorksheetDTO>> selectWorksheetByAsset(AssetWorksheetQueryDTO assetWorksheetQueryDTO);
}
