package com.ifourthwall.dbm.task.facade;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.dbm.task.dto.*;

import java.util.List;

/**
 * @author: fpc
 * @data: 2019/10/30 14:07
 * @Description:
 */
public interface ReportingFacade {

    /**
     * 新建报事
     * @author fpc
     * @date 2019/10/30 14:08
     * @param reportingInsertDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.lang.Object>
     */
    BaseResponse<Object> createReporting(ReportingInsertDTO reportingInsertDTO);

    /**
     * 分页查询报事列表
     * @author fpc
     * @date 2019/10/30 14:11
     * @param reportingQueryListDTO
     * @return com.ifourthwall.common.base.BaseResponse<com.github.pagehelper.PageInfo<com.ifourthwall.dbm.task.dto.ReportingDTO>>
     */
    BaseResponse<IFWPageInfo<ReportingDTO>> getReportingList(ReportingQueryListDTO reportingQueryListDTO);

    /**
     * seer分页查询报事列表，上面的数字统计
     * @param reportingQueryListDTO
     * @return
     */
    BaseResponse<List<SeerReportCountDTO>> getReportingCountForSeer(ReportingQueryListDTO reportingQueryListDTO);

    /**
     * 查询报事详情
     * @author fpc
     * @date 2019/10/30 14:13
     * @param reportingQueryDTO
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.task.dto.ReportingDTO>
     */
    BaseResponse<ReportingDTO> getReportingDetail(ReportingQueryDTO reportingQueryDTO);

    /**
     * 更新报事信息
     * @author fpc
     * @date 2019/10/31 11:46
     * @param reportingUpdateDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.lang.Object>
     */
    BaseResponse<Object> updateReporting(ReportingUpdateDTO reportingUpdateDTO);
}
