package com.ifourthwall.dbm.task.facade;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.dbm.task.dto.*;

import java.util.List;

/**
 * @author: fpc
 * @data: 2019/10/30 15:28
 * @Description:
 */
public interface PlanTaskCategoryFacade {

    /**
     * 创建计划任务目录
     * @author fpc
     * @date 2019/10/30 15:29
     * @param planTaskCategoryInsertDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.lang.Object>
     */
    BaseResponse<Object> createPlanTaskCategory(PlanTaskCategoryInsertDTO planTaskCategoryInsertDTO);

    /**
     * 启用/停用/删除 计划任务目录
     * @author fpc
     * @date 2019/10/30 15:38
     * @param planTaskCategoryOperateDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.lang.Object>
     */
    BaseResponse<Object> operatePlanTaskCategory(PlanTaskCategoryOperateDTO planTaskCategoryOperateDTO);

    /**
     * 查询计划任务目录列表
     * @author fpc
     * @date 2019/10/30 15:40
     * @param planTaskCategoryListQueryDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.task.dto.PlanTaskCategoryDTO>>
     */
    BaseResponse<List<PlanTaskCategoryDTO>> getPlanTaskCategoryList(PlanTaskCategoryListQueryDTO planTaskCategoryListQueryDTO);


    /**
     * 获取计划任务目录标签详情
     * @param planTaskCategoryListQueryDTO
     * @return
     */
    BaseResponse<List<MaintenanceTagDetailDTO>> getPlanTaskCategoryTagDetail(PlanTaskCategoryListQueryDTO planTaskCategoryListQueryDTO);

    /**
     * 创建计划任务目录标签返回planTaskCategoryTagId
     * @author fpc
     * @date 2019/10/31 14:19
     * @param planTaskCategoryTagInsertDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.lang.String>
     */
    BaseResponse<SingleStringOutDTO> createPlanTaskCategoryTag(PlanTaskCategoryTagInsertDTO planTaskCategoryTagInsertDTO);

    /**
     * 删除计划任务目录标签
     * @author fpc
     * @date 2019/10/31 14:21
     * @param planTaskCategoryTagQueryDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.lang.Object>
     */
    BaseResponse<Object> deletePlanTaskCategoryTag(PlanTaskCategoryTagQueryDTO planTaskCategoryTagQueryDTO);

    /**
     * 更新计划任务目标签
     * @author fpc
     * @date 2019/10/31 14:23
     * @param planTaskCategoryTagUpdateDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.lang.Object>
     */
    BaseResponse<Object> updatePlanTaskCategoryTag(PlanTaskCategoryTagUpdateDTO planTaskCategoryTagUpdateDTO);

    /**
     * 创建计划任务目录子任务
     * @author fpc
     * @date 2019/10/31 17:29
     * @param planTaskCategoryRelationInsertDTO
     * @return java.lang.Object
     */
    BaseResponse<SingleStringOutDTO> createPlanTaskCategorySubTask(PlanTaskCategoryRelationInsertDTO planTaskCategoryRelationInsertDTO);

    /**
     * 批量更新计划任务生效时间
     * @param planTaskValidTimeDTOList
     * @return
     */
    BaseResponse<Object> updatePlanTaskValidTime(List<PlanTaskValidTimeDTO> planTaskValidTimeDTOList);

    /**
     * 查询计划任务网格详情
     * @author fpc
     * @date 2019/11/11 15:09
     * @param planTaskCategoryDetailQueryDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.task.dto.TaskWithWorksheetListDTO>>
     */
    BaseResponse<List<PlanTaskDetailDTO>> getPlanTaskDetailList(PlanTaskCategoryDetailQueryDTO planTaskCategoryDetailQueryDTO);

    /**
     * 创建计划任务时，网格时间信息(根据年份，获取每月有几周，每周的开始时间)
     * @author fpc
     * @date 2019/11/29 15:02
     * @param planTaskMonthInfoQueryDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.task.dto.PlanTaskMonthInfoDTO>>
     */
    BaseResponse<List<PlanTaskMonthInfoDTO>> getPlanTaskWeekInfo(PlanTaskMonthInfoQueryDTO planTaskMonthInfoQueryDTO);


    /**
     * 新增服务供应商
     * @author fpc
     * @date 2019/12/11 10:14
     * @param serviceSupplierInsertDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.lang.Object>
     */
    BaseResponse<Object> insertServiceSupplier(ServiceSupplierInsertDTO serviceSupplierInsertDTO);

    /**
     * 删除服务供应商
     * @author fpc
     * @date 2019/12/11 10:12
     * @param serviceSupplierQueryDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.lang.Object>
     */
    BaseResponse<Object> deleteServiceSupplier(ServiceSupplierQueryDTO serviceSupplierQueryDTO);

    /**
     * 更新计划任务子任务
     * @author fpc
     * @date 2020/4/3 10:16
     * @param updatePlanTaskSubDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.lang.Object>
     */
    BaseResponse<Object> updatePlanTaskCategorySubTask(UpdatePlanTaskSubDTO updatePlanTaskSubDTO);

}
