package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author: fpc
 * @data: 2019/11/14 14:05
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class WorksheetSummeryListQueryDTO implements Serializable {
    /**
     * 查询方式 1-按周 2-按月 3-按年
     */
    @NotNull(message = PlatformCodeConstants.QUERY_TYPE_CANNOT_NULL)
    @ApiModelProperty(value = "查询方式 1-周 2-月 3-年",required = true)
    private Integer queryType;

    /**
     * 租户号
     */
    @NotBlank(message = PlatformCodeConstants.TENANT_ID_NOT_NULL)
    @ApiModelProperty(value = "租户号",required = true)
    private String tenantId;

    /**
     * 项目Id
     */
    @NotBlank(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    @ApiModelProperty(value = "项目Id",required = true)
    private String projectId;

    /**
     * 开始日期
     */
    @ApiModelProperty(value = "开始时间",required = true)
    private Date startDate;

    /**
     * 结束日期
     */
    @ApiModelProperty(value = "结束时间",required = true)
    private Date endDate;

    /**
     * 工单状态
     */
    private String worksheetStatusId;

    /**
     * 岗位Id
     */
    private List<String> positionIdList;

    /**
     * user id
     */
    private String userId;

}
