package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.util.Date;
import java.util.List;

@Data
@ToString(callSuper = true)
public class WorksheetStatisticListDTO extends PageCommonDTO {
    @NotBlank(message = PlatformCodeConstants.TENANT_ID_NOT_NULL)
    private String tenantId;

    /**
     * 项目id不能为空
     */
    @NotBlank(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

    /**
     * 任务周期 1-日 2-周 3-月
     */
    private Integer taskCycle;

    /**
     * 任务类型
     */
    private List<String> taskTypeIdList;

    /**
     * 工单状态列表
     */
    private List<String> worksheetStatusIdList;

    /**
     * 岗位id列表
     */
    private List<String> positionIdList;

    /**
     * 开始日期
     */
    private Date startDate;

    /**
     * 结束日期
     */
    private Date endDate;
}
