package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.List;

/**
 * @author: fpc
 * @data: 2019/11/26 14:57
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class WorksheetScanQueryDTO implements Serializable {

    /**
     * 租户号
     */
    @NotBlank(message = PlatformCodeConstants.TENANT_ID_NOT_NULL)
    @ApiModelProperty(value = "租户号",required = true)
    private String tenantId;

    /**
     * 项目Id
     */
    @NotBlank(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    @ApiModelProperty(value = "项目Id",required = true)
    private String projectId;

    /**
     * 用户Id
     */
    @NotBlank(message = PlatformCodeConstants.USER_ID_CANNOT_BE_EMPTY)
    @ApiModelProperty(value = "用户Id",required = true)
    private String userId;

    /**
     * 功能描述
     * @author fpc
     * @date 2019/12/16 11:17
     * @param
     * @return
     */
    @NotEmpty(message = PlatformCodeConstants.USER_POSITION_LIST_CANNOT_NULL)
    private List<String> subjectPermissionPositionIdList;

    /**
     * checkpointId集合
     */
    @NotEmpty(message = PlatformCodeConstants.CHECKPOINT_ID_LIST_CANNOT_NULL)
    @ApiModelProperty(value = "checkpointId集合",required = true)
    private List<String> checkpointIdList;
}
