package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * @author: fpc
 * @data: 2020/3/30 11:32
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class WorksheetQueryBySpaceDTO extends PageCommonDTO {

    @NotBlank(message = PlatformCodeConstants.TENANT_ID_NOT_NULL)
    private String tenantId;

    @NotBlank(message = PlatformCodeConstants.LANGUAGE_CODE_CANNOT_NULL)
    private String languageCode;

    @NotBlank(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

    /**
     * 空间id集合
     */
    private List<String> spaceIdList;
}
