package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @author: fpc
 * @data: 2019/11/6 18:26
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class WorksheetOperateDTO implements Serializable {

    /**
     * 工单基本信息
     */
    @NotNull(message = "工单基本信息不能为空")
    @ApiModelProperty(value = "工单基本信息",required = true)
    private TaskWorksheetUpdateDTO taskWorksheetUpdateDTO;

    /**
     * 事件基本信息
     */
    @ApiModelProperty(value = "事件基本信息")
    private WorksheetEventDTO worksheetEventDTO;

    /**
     * 事件对应消耗信息
     */
    @ApiModelProperty(value = "事件对应的消耗信息")
    private EventConsumptionDTO eventConsumptionDTO;

    /**
     * 事件对应图片信息
     */
    @ApiModelProperty(value = "事件对应的图片信息")
    private List<WorksheetEventPictureDTO> worksheetEventPictureDTOList;

    /**
     * 事件对应岗位信息
     */
    @ApiModelProperty(value = "事件对应的岗位信息")
    private List<WorksheetEventPositionDTO> worksheetEventPositionDTOList;

    /**
     * 事件对应user信息
     */
    @ApiModelProperty(value = "事件对应的user信息")
    private List<WorksheetEventUserDTO> worksheetEventUserDTOList;

    /**
     * 宾语岗位Id
     */
    @NotEmpty(message = PlatformCodeConstants.CREATOR_POSITION_ID_CANNOT_NULL)
    @ApiModelProperty(value = "工单创建人岗位Id",required = true)
    private String permissionObjectPositionId;

    /**
     * 主语岗位Id
     */
    @NotEmpty(message = PlatformCodeConstants.SUBJECT_POSITION_ID_INFO_CANNOT_NULL)
    @ApiModelProperty(value = "主语岗位Id信息",required = true)
    private List<String> subjectPermissionPositionIdList;

    /**
     * 任务模版Id
     */
    @NotEmpty(message = PlatformCodeConstants.TASK_TEMPLATE_ID_CANNOT_NULL)
    @ApiModelProperty(value = "任务模版Id",required = true)
    private String taskTemplateId;

    /**
     * 验收0-通过 1-不通过
     */
    private String checkPass;

    /**
     * 父级空间id集合
     */
    private List<String> parentSpaceIdList;
}
