package com.ifourthwall.dbm.task.dto;

import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.List;

@Data
@ToString(callSuper = true)
public class WorksheetListForSeerDTO implements Serializable {
    /**
     * 工单Id
     */
    private String worksheetId;

    private String worksheetNo;

    /**
     * 工单状态Id
     */
    private String worksheetStatusId;

    /**
     * 执行人信息
     */
    private List<WorksheetExecutorDTO> executorList;

    /**
     * 任务类型
     */
    private String taskType;

    /**
     * 创建时间
     */
    private String createTime;

    /**
     * 更新时间
     */
    private String updateTime;

    /**
     * 过期时间
     */
    private String expireTime;

    /**
     * 特殊标志
     */
    private String specicalFlag;

    /**
     * 任务创建来源(1.直接创建 2.巡视创建 3.报事创建 4.自动告警创建)
     */
    private String taskSource;

    private String contentValue;
}
