package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Data
@ToString
public class WorksheetListChartByDeptQueryDTO implements Serializable {
    /**
     * 租户号
     */
    @NotBlank(message = PlatformCodeConstants.TENANT_ID_NOT_NULL)
    private String tenantId;

    /**
     * 项目Id
     */
    @NotBlank(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

    /**
     * 开始日期
     */
    private Date startDate;

    /**
     * 结束日期
     */
    private Date endDate;

    /**
     * 空间id集合
     */
    private List<String> spaceIdList;
}
