package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author: fpc
 * @data: 2019/11/12 18:22
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class WorksheetListByCheckpointQueryDTO implements Serializable {
    /**
     * 租户号
     */
    @NotBlank(message = PlatformCodeConstants.TENANT_ID_NOT_NULL)
    @ApiModelProperty(value = "租户号",required = true)
    private String tenantId;

    /**
     * 项目Id
     */
    @NotBlank(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    @ApiModelProperty(value = "项目Id",required = true)
    private String projectId;

    /**
     * checkpointId
     */
    @NotBlank(message = PlatformCodeConstants.CHECKPOINT_ID_LIST_CANNOT_NULL)
    @ApiModelProperty(value = "checkpointId",required = true)
    private String checkpointId;
}
