package com.ifourthwall.dbm.task.dto;

import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author: fpc
 * @data: 2019/11/8 16:39
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class WorksheetEventSupperWrapDTO implements Serializable {

    /**
     * 租户id
     */
    private String tenantId;

    /**
     * 任务事件id
     */
    private String worksheetEventId;

    /**
     * 任务id
     */
    private String worksheetId;

    /**
     * 项目id
     */
    private String projectId;

    /**
     * 任务操作id
     */
    private String taskOperationId;

    /**
     * 操作名称
     */
    private String taskOperationName;

    /**
     * 反馈评价结果
     */
    private String worksheetEventResult;

    /**
     * 任务事件内容
     */
    private String worksheetEventContent;

    /**
     * 扫描路线次数编号
     */
    private String scanRouteUuid;

    /**
     * 轨迹实体名称
     */
    private String traceEntityName;

    /**
     * 轨迹数据
     */
    private String traceData;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 创建者user_id
     */
    private String createBy;


    /**
     * 检查点id
     */
    private String checkpointId;


    /**
     * 消耗类型 1 物料消耗 2 金额备注
     */
    private String consumptionType;

    /**
     * 消耗品名称
     */
    private String consumptionName;

    /**
     * 消耗品价格
     */
    private BigDecimal price;

    /**
     * 备注
     */
    private String remark;

    /**
     * 支付时间
     */
    private Date payTime;

    /**
     * 工单事件对应图片信息
     */
    List<WorksheetEventPictureDTO> worksheetEventPictureList;

    /**
     * 工单事件对应岗位信息
     */
    List<WorksheetEventPositionDTO> worksheetEventPositionList;

    /**
     * 工单事件对应user信息
     */
    List<WorksheetEventUserDTO> worksheetEventUserList;

    /**
     * 工单事件检查点对应资产信息
     */
    List<AssetCheckRecordDTO> assetCheckRecordList;
}
