package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author: fpc
 * @data: 2019/11/7 18:06
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class WorksheetEventDetailQueryDTO implements Serializable {

    /**
     * 租户号
     */
    @NotBlank(message = PlatformCodeConstants.TENANT_ID_NOT_NULL)
    private String tenantId;

    /**
     * 工单事件
     */
    @NotBlank(message = PlatformCodeConstants.WORKSHEET_ID_CANNOT_NULL)
    private String worksheetEventId;
}
