package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.Date;

/**
 * @author: fpc
 * @data: 2019/11/6 15:35
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class WorksheetEventDTO implements Serializable {
    /**
     * 租户id
     */
    @NotEmpty(message = PlatformCodeConstants.TENANT_ID_NOT_NULL)
    @ApiModelProperty(value = "租户号",required = true)
    private String tenantId;

    /**
     * 任务事件id
     */
    private String worksheetEventId;

    /**
     * 工单id
     */
    @NotEmpty(message = PlatformCodeConstants.TASK_WORKSHEET_ID_CANNOT_NULL)
    @ApiModelProperty(value = "工单Id",required = true)
    private String worksheetId;

    /**
     * 项目id
     */
    @NotEmpty(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    @ApiModelProperty(value = "项目Id",required = true)
    private String projectId;

    /**
     * 任务操作id
     */
    private String taskOperationId;

    /**
     * 反馈评价结果
     */
    @ApiModelProperty(value = "反馈评价结果（1 2 3 星）")
    private String worksheetEventResult;

    /**
     * 任务事件内容
     */
    @ApiModelProperty(value = "时间内容（备注内容）")
    private String worksheetEventContent;

    /**
     * 扫描路线次数编号
     */
    @ApiModelProperty(value = "扫描路线次数编号(巡视任务 和 固定任务必传)")
    private String scanRouteUuid;

    /**
     * 轨迹实体名称
     */
    private String traceEntityName;

    /**
     * 轨迹数据
     */
    private String traceData;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 创建者user_id
     */
    @NotBlank(message = PlatformCodeConstants.CREATE_USER_ID_CANNOR_NULL)
    @ApiModelProperty(value = "事件创建人userId",required = true)
    private String createBy;
}
