package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.List;

/**
 * @author: fpc
 * @data: 2019/11/6 15:39
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class WorksheetEventCheckpointDTO implements Serializable {
    /**
     * 租户id
     */
    private String tenantId;

    /**
     * 工单事件id
     */
    private String worksheetEventId;

    /**
     * 检查点id
     */
    @NotBlank(message = PlatformCodeConstants.CHECKPOINT_ID_LIST_CANNOT_NULL)
    @ApiModelProperty(value = "检查点Id",required = true)
    private String checkpointId;

    /**
     * 对应checkpoint检查资产记录信息
     */
    @NotEmpty(message = PlatformCodeConstants.ASSET_RECORD_CANNOT_NULL)
    @ApiModelProperty(value = "资产记录信息",required = true)
    private List<AssetCheckRecordDTO> assetCheckRecordList;
}
