package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author: fpc
 * @data: 2019/11/6 17:19
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class WorksheetDetailQueryDTO implements Serializable {
    /**
     * 任务工单id
     */
    @ApiModelProperty(value = "任务工单Id")
    private String taskWorksheetId;


    @ApiModelProperty(value = "任务Id")
    private String taskId;

    /**
     * 项目Id
     */
    @NotBlank(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    @ApiModelProperty(value = "项目Id",required = true)
    private String projectId;

    /**
     * 租户号
     */
    @NotBlank(message = PlatformCodeConstants.TENANT_ID_NOT_NULL)
    @ApiModelProperty(value = "租户号",required = true)
    private String tenantId;

    @NotBlank(message = PlatformCodeConstants.LANGUAGE_CODE_CANNOT_NULL)
    private String languageCode;

}
