package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.List;

/**
 * @author: fpc
 * @data: 2019/12/13 10:21
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class WorksheetAssignListQueryDTO implements Serializable {
    /**
     * 任务工单id
     */
    @NotBlank(message = PlatformCodeConstants.TASK_WORKSHEET_ID_CANNOT_NULL)
    private String taskWorksheetId;

    /**
     * 项目Id
     */
    @NotBlank(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

    /**
     * 租户号
     */
    @NotBlank(message = PlatformCodeConstants.TENANT_ID_NOT_NULL)
    private String tenantId;

    /**
     * 主语岗位Id
     */
    @NotEmpty(message = PlatformCodeConstants.SUBJECT_POSITION_ID_INFO_CANNOT_NULL)
    private List<String> permissionSubjectPositionIdList;

}
