package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @author: fpc
 * @data: 2019/11/22 10:41
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class UploadScanWrapDTO implements Serializable {

    /**
     * 工单事件基本信息
     */
    @NotNull(message = PlatformCodeConstants.WORKSHEET_EVENT_BASIC_CANNOT_NULL)
    @ApiModelProperty(value = "工单事件基本信息",required = true)
    private WorksheetEventDTO worksheetEvent;

    /**
     * 事件checkpoint检查信息
     */
    @ApiModelProperty(value = "事件checkpoint检查信息（巡视任务时必传）")
    private WorksheetEventCheckpointDTO worksheetEventCheckpoint;

    @ApiModelProperty(value = "巡点图片信息")
    private List<WorksheetEventPictureDTO> worksheetEventPictureList;

    @NotEmpty(message = PlatformCodeConstants.SUBJECT_POSITION_ID_INFO_CANNOT_NULL)
    private List<String> subjectPermissionPositionIdList;

    @Valid
    private List<MeterInfoDTO> meterInfoList;
}
