package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import lombok.Data;
import lombok.ToString;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author: fpc
 * @data: 2020/4/3 10:13
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class UpdatePlanTaskSubDTO implements Serializable {

    @NotBlank(message = PlatformCodeConstants.TENANT_ID_NOT_NULL)
    private String tenantId;

    /**
     * 计划任务目录id
     */
    @NotBlank(message = PlatformCodeConstants.PPM_CATEGPRY_ID_CANNOT_NULL)
    private String planTaskCategoryId;

    /**
     * 计划任务保养类型标签id
     */
    @NotBlank(message =  PlatformCodeConstants.PPM_MAINTENANCE_TAG_ID_CANNOT_NULL)
    private String planTaskMaintenanceTagId;

    /**
     * 计划任务系统标签id
     */
    @NotBlank(message = PlatformCodeConstants.PPM_SYSTEM_TAG_ID_CANNOT_NULL)
    private String planTaskSystemTagId;


    @NotNull(message = PlatformCodeConstants.TASK_DETAIL_INFO_CANNOT_NULL)
    @Valid
    TaskWrapInsertDTO taskWrap;
}
