package com.ifourthwall.dbm.task.dto;

import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author: fpc
 * @data: 2019/11/1 18:28
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class TemporyTaskWorkSheetListDTO implements Serializable {

    /**
     * 工单id
     */
    private String taskWorksheetId;

    /**
     * 工单号
     */
    private String worksheetNo;

    /**
     * 工单状态
     */
    private String worksheetStatusId;

    /**
     * 特殊状态标志
     */
    private String specicalFlag;

    /**
     * 反馈标志
     */
    private String feedbackFlag;

    /**
     * 过期标志
     */
    private String expiredFlag;
    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 创建者user_id
     */
    private String createBy;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 更新者user_id
     */
    private String updateBy;

    /**
     * 过期时间
     */
    private Date expireTime;

    /**
     * 任务类型
     */
    private String taskTypeId;

    /**
     * 任务名称
     */
    private String taskName;
    /**
     * 任务模板id
     */
    private String taskTemplateId;
    /**
     * 任务模版名称
     */
    private String taskTemplateName;


    /**
     * 任务空间名称
     */
    private List<TaskSpaceInsertDTO> taskSpaceList;


    /**
     * 负责岗位
     */
    private List<WorksheetExecutorDTO> worksheetExecutorList;
}
