package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.util.Date;
import java.util.List;

/**
 * @author: fpc
 * @data: 2020/3/9 14:36
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class TempTaskWorksheetQueryDTO extends PageCommonDTO{

    /**
     * 租户号
     */
    @NotBlank(message = PlatformCodeConstants.TENANT_ID_NOT_NULL)
    private String tenantId;

    /**
     * 项目Id
     */
    @NotBlank(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

    /**
     * 任务基本类型 1-临时任务 2-固定任务 3-巡视任务 4-计划任务 集合
     */
    private List<String> taskTypeIdList;

    /**
     * 工单状态
     */
    private List<String> worksheetStatusIdList;

    /**
     * 任务模版id集合
     */
    private List<String> taskTemplateIdList;

    /**
     * 执行人岗位集合
     */
    private List<String> permissionSubjectPositionIdList;

    /**
     * 执行人用户id
     */
    private String executorUserId;


    /**
     * 创建人userId
     */
    private List<String> createUserIdList;

    /**
     * 工单号
     */
    private String worksheetNo;

    /**
     * 任务名称
     */
    private String taskName;

    /**
     * 开始时间
     */
    private Date startDate;

    /**
     * 结束时间
     */
    private Date endDate;


    /**
     * 1.创建时间 2.更新时间 3.创建时间正序
     */
    private String queryType;

    /**
     * 0-超时 1-未超时
     */
    private String isExpire;

    /**
     * 当前日期
     */
    private Date currentDate;

    /**
     * 0-已完成 1-未完成
     */
    private String isFinished;

    List<TemplateAndCreateDTO> templateAndCreateList;

    private List<String> spaceIdList;

}
