package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @author: fpc
 * @data: 2019/10/31 10:28
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class TaskWrapInsertDTO implements Serializable {

    /**
     * 任务基本信息
     */
    @Valid
    @NotNull(message = PlatformCodeConstants.TASK_BASIC_INFO_CANNOT_NULL)
    private TaskInsertDTO task;

    /**
     * 任务图片集合信息
     */
    @ApiModelProperty(value = "任务图片信息")
    private List<TaskPictureInsertDTO> taskPictureList;

    /**
     * 任务执行人集合信息
     */
//    @NotEmpty(message = "任务执行人数据不能为空")
    @ApiModelProperty(value = "任务执行人信息")
    private List<TaskExecutorInsertDTO> taskExecutorList;

    /**
     * 任务空间信息
     */
    @ApiModelProperty(value = "任务空间信息（临时任务、计划任务传）")
    private List<TaskSpaceInsertDTO> taskSpaceList;

    /**
     * 任务相关的checkpoint信息
     */
    @ApiModelProperty(name = "checkpoint信息（巡视任务、固定岗任务传）")
    private List<TaskCheckPointRelationInsertDTO> taskCheckPointRelationList;

//    @NotEmpty(message = "创建人岗位Id不能为空")
//    @ApiModelProperty(value = "创建人岗位Id",required = true)
//    private List<String> permissionSubjectPositionIdList;


}
