package com.ifourthwall.dbm.task.dto;

import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.List;

/**
 * @author: fpc
 * @data: 2019/11/1 11:57
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class TaskWrapDetailDTO implements Serializable {

    private TaskInsertDTO taskInsertDTO;

    /**
     * 任务图片集合信息
     */
    private List<TaskPictureInsertDTO> taskPictureInsertDTOList;

    /**
     * 任务执行人集合信息
     */
    @NotEmpty(message = "任务执行人数据不能为空")
    private List<TaskExecutorInsertDTO> taskExecutorInsertDTOList;

    /**
     * 任务空间信息
     */
    private List<TaskSpaceInsertDTO> taskSpaceInsertDTOList;

    /**
     * 任务相关的checkpoint信息
     */
    private List<TaskCheckPointRelationInsertDTO> taskCheckPointRelationInsertDTOList;

    /**
     * 计划任务服务提供方
     */
    private ServiceSupplierInsertDTO serviceSupplierInsertDTO;
}
