package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Date;

/**
 * @author: fpc
 * @data: 2019/11/7 17:16
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class TaskWorksheetUpdateDTO implements Serializable {
    /**
     * 租户id
     */
    @NotBlank(message = PlatformCodeConstants.TENANT_ID_NOT_NULL)
    private String tenantId;

    /**
     * 0 - 生效 1 - 未生效 2 - 删除
     */
    private String valid;

    /**
     * 任务工单id
     */
    @NotBlank(message = PlatformCodeConstants.TASK_WORKSHEET_ID_CANNOT_NULL)
    private String taskWorksheetId;

    /**
     * 任务工单号
     */
    private String worksheetNo;

    /**
     * 项目id
     */
    @NotBlank(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

    /**
     * 任务id
     */
    private String taskId;

    /**
     * 工单状态
     */
    private String worksheetStatusId;

    /**
     * 任务模板标签id
     */
    private String taskTemplateTagId;

    /**
     * 特殊状态标志
     */
    private String specicalFlag;

    /**
     * 反馈标志
     */
    private String feedbackFlag;

    /**
     * 过期标志
     */
    private String expiredFlag;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 创建者user_id
     */
    private String createBy;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 更新者user_id
     */
    @NotBlank(message = PlatformCodeConstants.UPDATE_USER_IS_NULL)
    private String updateBy;

    /**
     * 过期时间
     */
    private Date expireTime;
}
