package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author: fpc
 * @data: 2020/3/12 16:54
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class TaskWorksheetListQueryDTO implements Serializable {

    /**
     * 任务id
     */
    @NotBlank(message = PlatformCodeConstants.TASK_ID_CANNOT_NULL)
    private String taskId;

    /**
     * 租户Id
     */
    @NotBlank(message = PlatformCodeConstants.TENANT_ID_NOT_NULL)
    private String tenantId;

    /**
     * 项目Id
     */
    @NotBlank(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

    /**
     * 查询几条
     */
    private Integer limitNum;
}
