package com.ifourthwall.dbm.task.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @author: fpc
 * @data: 2019/11/6 17:00
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class TaskWorksheetInsertWrapDTO implements Serializable {

    /**
     * 工单的基本信息
     */
    @NotNull(message = "工单基本信息不能为空")
    @ApiModelProperty(value = "工单基本信息",required = true)
    private TaskWorksheetDTO taskWorksheetDTO;

    /**
     * 工单的执行人信息
     */
    @NotEmpty(message = "工单执行人信息不能为空")
    @ApiModelProperty(value = "工单执行信息",required = true)
    private List<WorksheetExecutorDTO> worksheetExecutorDTOList;
}
