package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Date;

/**
 * @author: fpc
 * @data: 2019/11/6 17:01
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class TaskWorksheetDTO implements Serializable {
    /**
     * 租户id
     */
    @NotBlank(message = PlatformCodeConstants.TENANT_ID_NOT_NULL)
    @ApiModelProperty(value = "租户号",required = true,hidden = true)
    private String tenantId;

    /**
     * 0 - 生效 1 - 未生效 2 - 删除
     */
    private String valid;

    /**
     * 任务工单id
     */
    @ApiModelProperty(value = "任务工单Id",hidden = true)
    private String taskWorksheetId;

    /**
     * 任务工单号
     */
    @ApiModelProperty(value = "任务工单号")
    private String worksheetNo;

    /**
     * 项目id
     */
    @NotBlank(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    @ApiModelProperty(value = "项目Id",required = true)
    private String projectId;

    /**
     * 任务id
     */
    @ApiModelProperty(value = "任务Id")
    private String taskId;

    /**
     * 工单状态
     */
    @ApiModelProperty(value = "工单状态")
    private String worksheetStatusId;

    /**
     * 任务模板标签id
     */
    @ApiModelProperty(value = "任务模版标签Id")
    private String taskTemplateTagId;

    /**
     * 特殊状态标志
     */
    @ApiModelProperty(value = "特殊状态标志")
    private String specicalFlag;

    /**
     * 过期标志
     */
    @ApiModelProperty(value = "过期标志")
    private String expiredFlag;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    /**
     * 创建者user_id
     */
    @ApiModelProperty(value = "创建人userId")
    private String createBy;

    /**
     * 更新时间
     */
    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

    /**
     * 更新者user_id
     */
    @ApiModelProperty(value = "更新人userId")
    private String updateBy;

    /**
     * 过期时间
     */
    @ApiModelProperty(value = "过期时间")
    private Date expireTime;

    private String taskName;
}
