package com.ifourthwall.dbm.task.dto;

import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author: fpc
 * @data: 2019/12/19 15:09
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class TaskWithWorksheetWithCheckpointDTO implements Serializable {

    /**
     * 工单Id
     */
    private String taskWorksheetId;

    /**
     * 租户id
     */
    private String tenantId;

    /**
     * 任务id
     */
    private String taskId;

    /**
     * 是否有效  0 - 生效 1 - 未生效 2 - 删除
     */
    private String valid;

    /**
     * 项目id
     */
    private String projectId;

    /**
     * 任务类型id
     */
    private String taskTypeId;

    /**
     * 任务模版id
     */
    private String taskTemplateId;

    /**
     * 任务名称
     */
    private String taskName;

    /**
     * 任务描述
     */
    private String taskDescription;

    /**
     * 服务供应商id
     */
    private String serviceSupplierId;

    /**
     * 需要在岗时间分钟 （固定岗任务需要）
     */
    private Integer workingMiniute;

    /**
     * 巡视次数（巡视任务需要）
     */
    private Integer patrolCount;

    /**
     * 巡视是否有序（巡视任务需要）
     */
    private Integer patrolInOrder;

    /**
     * 巡视是否需要gps定位（巡视任务需要）
     */
    private Integer patrolNeedGps;

    /**
     * 任务周期（1.每日2.每周3.每月 4.每月第一周 5.每月第二周 6.每月第三周 7.每月第四周 8.每月一三周 9.每月二四周）
     */
    private Integer taskCycle;

    /**
     * 相关报事报修id
     */
    private String reportingId;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 创建人user_id
     */
    private String createBy;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 更新人user_id
     */
    private String updateBy;

    /**
     * 点位信息
     */
    private List<CheckpointDTO> checkpointList;
}
