package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author: fpc
 * @data: 2019/10/25 17:27
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class TaskTemplateWarpQueryDTO implements Serializable {
    /**
     * 任务模版id
     */
    @NotBlank(message = PlatformCodeConstants.TASK_TEMPLATE_ID_CANNOT_NULL)
    @ApiModelProperty(value = "任务模版Id",required = true)
    private String taskTemplateId;

    /**
     * 租户号
     */
    @NotBlank(message = PlatformCodeConstants.TENANT_ID_NOT_NULL)
    @ApiModelProperty(value = "租户Id",required = true,hidden = true)
    private String tenantId;

    /**
     * 项目Id不能为空
     */
    @NotBlank(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    @ApiModelProperty(value = "项目Id",required = true)
    private String projectId;

}
