package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @author: fpc
 * @data: 2019/10/30 10:17
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class TaskTemplateUpdateWrapDTO implements Serializable {
    /**
     * 任务模版基本信息
     */
    @NotNull(message = PlatformCodeConstants.TASK_TEMPLATE_BASIC_INFO_CANNOT_NULL)
    @ApiModelProperty(value = "任务模版基本信息",required = true)
    private TaskTemplateUpdateDTO taskTemplateUpdateDTO;

    /**
     * 任务模版标签信息
     */
    @ApiModelProperty(value = "任务模版标签信息（临时任务模版需要，其他不需要）")
    private List<TaskTemplateTagReleationDTO> taskTemplateTagReleationDTOList;

    /**
     * 任务模版权限信息
     */
    @ApiModelProperty(value = "任务模版权限信息")
    private List<TaskTemplatePermissionRelationDTO> taskTemplatePermissionRelationDTOList;

}
