package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Date;

/**
 * @author: fpc
 * @data: 2019/10/30 10:48
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class TaskTemplateUpdateDTO implements Serializable {

    /**
     * 租户号
     */
    @NotBlank(message = PlatformCodeConstants.TENANT_ID_NOT_NULL)
    @ApiModelProperty(value = "租户Id",required = true,hidden = true)
    private String tenantId;

    /**
     * 项目Id
     */
    @NotBlank(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    @ApiModelProperty(value = "项目Id",required = true)
    private String projectId;

    /**
     * 任务模版id
     */
    @NotBlank(message = PlatformCodeConstants.TASK_TEMPLATE_ID_CANNOT_NULL)
    @ApiModelProperty(value = "任务模版Id",required = true)
    private String taskTemplateId;

    /**
     * 任务模版名称
     */
    @ApiModelProperty(value = "任务模版名称")
    private String taskTemplateName;

    /**
     * 任务模版图标
     */
    @ApiModelProperty(value = "任务模版图标")
    private String taskTemplateIcon;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 更新者user_id
     */
    @NotBlank(message = PlatformCodeConstants.UPDATE_USER_IS_NULL)
    @ApiModelProperty(value = "更新人userId",required = true,hidden = true)
    private String updateBy;
}
