package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author: fpc
 * @data: 2019/10/25 17:38
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class TaskTemplateTagUpdateDTO implements Serializable {

    /**
     * 任务模版标签id
     */
    @NotBlank(message = PlatformCodeConstants.TASK_TEMPLATE_TAG_ID_CANNOT_NULL)
    @ApiModelProperty(value = "任务模版标签Id",required = true)
    private String taskTemplateTagId;

    /**
     * 任务模版标签名称
     */
    @ApiModelProperty(value = "任务模版标签名称")
    private String taskTemplateTagName;

    @ApiModelProperty(value = "0-有效 1-失效 2-删除")
    private String valid;

    /**
     * 租户号
     */
    @NotBlank(message = PlatformCodeConstants.TENANT_ID_NOT_NULL)
    @ApiModelProperty(value = "租户Id",required = true,hidden = true)
    private String tenantId;

    /**
     * 项目Id
     */
    @NotBlank(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    @ApiModelProperty(value = "项目Id",required = true)
    private String projectId;

    /**
     * 更新人id
     */
    @NotBlank(message = PlatformCodeConstants.UPDATE_USER_IS_NULL)
    @ApiModelProperty(value = "更新人userId",required = true,hidden = true)
    private String updateBy;

}
