package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author: fpc
 * @data: 2019/10/29 11:40
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class TaskTemplateTagReleationDTO implements Serializable {
    /**
     * 租户号
     */
    private String tenantId;

    /**
     * 任务模版id
     */
    private String taskTemplateId;

    /**
     * 任务模版标签id
     */
    @NotBlank(message = PlatformCodeConstants.TASK_TEMPLATE_TAG_ID_CANNOT_NULL)
    @ApiModelProperty(value = "任务模版标签Id",required = true)
    private String taskTempalteTagId;
}
