package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author: fpc
 * @data: 2019/10/25 16:47
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class TaskTemplateTagInsertDTO implements Serializable {
    /**
     * 租户号
     */
    @NotBlank(message = PlatformCodeConstants.TENANT_ID_NOT_NULL)
    @ApiModelProperty(value = "租户Id",required = true,hidden = true)
    private String tenantId;

    /**
     * 项目Id
     */
    @NotBlank(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    @ApiModelProperty(value = "项目Id",required = true)
    private String projectId;

    /**
     * 任务模版标签名称
     */
    @NotBlank(message = PlatformCodeConstants.TASK_TEMPLATE_TAG_CANNOT_NULL)
    @ApiModelProperty(value = "任务模版标签名称",required = true)
    private String taskTemplateTagName;

    @NotBlank(message = PlatformCodeConstants.CREATE_USER_ID_CANNOR_NULL)
    @ApiModelProperty(value = "创建人userId",required = true,hidden = true)
    private String createBy;
}
