package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author: fpc
 * @data: 2020/1/11 11:03
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class TaskTemplateTagDetailQueryDTO implements Serializable {

    /**
     * 租户号
     */
    @NotBlank(message = PlatformCodeConstants.TENANT_ID_NOT_NULL)
    private String tenantId;

    /**
     * 项目Id
     */
    @NotBlank(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

    /**
     * 任务模版标签Id
     */
    @NotBlank(message = PlatformCodeConstants.TASK_TEMPLATE_TAG_ID_CANNOT_NULL)
    private String taskTemplateTagId;
}
