package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.List;

/**
 * @author: fpc
 * @data: 2020/4/16 13:39
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class TaskTemplateQueryByIdListDTO implements Serializable {

    @NotBlank(message = PlatformCodeConstants.TENANT_ID_NOT_NULL)
    private String tenantId;

    /**
     * 模版Id集合
     */
    @NotEmpty(message = PlatformCodeConstants.TASK_TEMPLATE_ID_CANNOT_NULL)
    private List<String> taskTemplateIdList;

    /**
     * 操作Id集合
     */
    private String operationId;

    /**
     * 主语岗位Id集合
     */
    private List<String> subjectPositionId;
}
