package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.List;

/**
 * @author: fpc
 * @data: 2019/11/11 18:41
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class TaskTemplatePermissionRelationQueryDTO implements Serializable {
    /**
     * 租户Id
     */
    @NotBlank(message = PlatformCodeConstants.TENANT_ID_NOT_NULL)
    @ApiModelProperty(value = "租户Id",required = true,hidden = true)
    private String tenantId;

    /**
     * 任务模版Id
     */
    @NotBlank(message = PlatformCodeConstants.TASK_TEMPLATE_ID_CANNOT_NULL)
    @ApiModelProperty(value = "任务模版Id",required = true)
    private String taskTemplateId;

    /**
     * 操作Id
     */
    @NotBlank(message = PlatformCodeConstants.PERMISSION_OPERATE_ID_CANNOT_NULL)
    @ApiModelProperty(value = "权限操作Id",required = true)
    private String permissionTaskOperationId;

    /**
     * 主语岗位Id
     */
    @NotEmpty(message = PlatformCodeConstants.POSITION_ID_CANNOT_NULL)
    @ApiModelProperty(value = "主语岗位Id",required = true,hidden = true)
    private List<String> permissionSubjectPositionIdList;
}
