package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author: fpc
 * @data: 2019/10/25 17:44
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class TaskTemplatePermissionRelationDTO implements Serializable {

    /**
     * 租户id
     */
    private String tenantId;

    /**
     * 任务模版id
     */
    private String taskTemplateId;

    /**
     * 权限岗位主语
     */
    @NotBlank(message = PlatformCodeConstants.SUBJECT_POSITION_ID_INFO_CANNOT_NULL)
    @ApiModelProperty(value = "权限岗位主语Id",required = true)
    private String permissionSubjectPositionId;

    /**
     * 权限岗位宾语
     */
    private String permissionObjectPositionId;

    /**
     * 权限任务操作id
     */
    @NotBlank(message = PlatformCodeConstants.PERMISSION_OPERATE_ID_CANNOT_NULL)
    @ApiModelProperty(value = "权限任务操作Id",required = true)
    private String permissionTaskOperationId;
}
