package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author: fpc
 * @data: 2019/10/31 17:10
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class TaskTemplatePermissionExecutorQueryDTO implements Serializable {
    /**
     * 任务模版id
     */
    @NotBlank(message = PlatformCodeConstants.TASK_TEMPLATE_ID_CANNOT_NULL)
    @ApiModelProperty(value = "任务模版Id",required = true)
    private String taskTemplateId;

    @NotBlank(message = PlatformCodeConstants.TENANT_ID_NOT_NULL)
    @ApiModelProperty(value = "租户号",required = true)
    private String tenantId;

    /**
     * 权限任务操作id 1-发布临时任务 2-查询他人任务 3-分配他人任务 4-升级他人任务 5-分享他人任务 6-标签修改删除 7-内容修改 8-执行任务 9-特殊任务执行
     * 10-抢单 11-反馈他人任务 12-发布固定任务 13-执行固定任务 14-查询固定任务 15-发布巡视任务 16-查询巡视任务 17-执行巡视任务
     */
    @ApiModelProperty(value = "任务权限操作Id")
    private String permissionTaskOperationId;
}
