package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author: fpc
 * @data: 2019/10/29 17:21
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class TaskTemplateListQueryDTO implements Serializable {
    /**
     * 租户号
     */
    @NotBlank(message = PlatformCodeConstants.TENANT_ID_NOT_NULL)
    @ApiModelProperty(value = "租户Id",required = true,hidden = true)
    private String tenantId;

    /**
     * 项目Id
     */
    @NotBlank(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    @ApiModelProperty(value = "项目Id",required = true)
    private String projectId;

    /**
     * 任务基本类型
     */
    private String taskTypeId;

    /**
     * 主语岗位Id
     */
    private String permissionSubjectPositionId;

    /**
     * 权限任务操作id 1-发布临时任务 2-查询他人任务 3-分配他人任务 4-升级他人任务 5-分享他人任务 6-标签修改删除 7-内容修改 8-执行任务 9-特殊任务执行
     * 10-抢单 11-反馈他人任务 12-发布固定任务 13-执行固定任务 14-查询固定任务 15-发布巡视任务 16-查询巡视任务 17-执行巡视任务
     */
    private String permissionTaskOperationId;
}
