package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.List;

/**
 * @author: fpc
 * @data: 2019/11/8 10:13
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class TaskTemplateListByOperationQueryDTO implements Serializable {
    /**
     * 租户号
     */
    @NotBlank(message = PlatformCodeConstants.TENANT_ID_NOT_NULL)
    @ApiModelProperty(value = "租户Id",required = true,hidden = true)
    private String tenantId;

    /**
     * 项目Id
     */
    @NotBlank(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    @ApiModelProperty(value = "项目Id",required = true)
    private String projectId;

    /**
     * 任务基本类型 1-临时任务 2-固定任务 3-巡视任务 4-计划任务
     */
    @ApiModelProperty(value = "任务类型Id集合")
    private List<String> taskTypeIdList;

    /**
     * 主语岗位Id
     */
    @ApiModelProperty(value = "主语岗位Id",hidden = true)
    private List<String> permissionSubjectPositionIdList;

    /**
     * 权限任务操作id 1-发布临时任务 2-查询他人任务 3-委派他人任务 4-升级他人任务 5-分享他人任务 6-标签修改删除 7-内容修改 8-执行任务 9-特殊任务执行
     * 10-抢单 11-反馈他人任务 12-发布固定任务 13-执行固定任务 14-查询固定任务 15-发布巡视任务 16-查询巡视任务 17-执行巡视任务
     */
    @ApiModelProperty(value = "任务操作Id")
    private String permissionTaskOperationId;
}
