package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @author: fpc
 * @data: 2019/10/29 14:07
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class TaskTemplateInsertWrapDTO implements Serializable {

    /**
     * 任务模版基本信息
     */
    @NotNull(message = PlatformCodeConstants.TASK_TEMPLATE_BASIC_INFO_CANNOT_NULL)
    @ApiModelProperty(value = "任务模版基本信息",required = true)
    private TaskTemplateInsertDTO taskTemplateInsertDTO;

    /**
     * 任务模版标签信息
     */
    @ApiModelProperty(value = "任务模版标签信息(临时任务必传，固定任务/巡视任务/计划任务 不传)")
    private List<TaskTemplateTagReleationDTO> taskTemplateTagReleationDTOList;

    /**
     * 任务模版权限信息
     */
    @ApiModelProperty(value = "任务模版权限信息")
    private List<TaskTemplatePermissionRelationDTO> taskTemplatePermissionRelationDTOList;
}
