package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Date;

/**
 * @author: fpc
 * @data: 2019/10/29 15:20
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class TaskTemplateInsertDTO implements Serializable {

    /**
     * 租户号
     */
    @NotBlank(message = PlatformCodeConstants.TENANT_ID_NOT_NULL)
    @ApiModelProperty(value = "租户Id",required = true,hidden = true)
    private String tenantId;

    /**
     * 0 - 生效 1 - 未生效 2 - 删除
     */
    private String valid;

    /**
     * 项目id
     */
    @NotBlank(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    @ApiModelProperty(value = "项目Id",required = true)
    private String projectId;

    /**
     * 任务模版id
     */
    private String taskTemplateId;

    /**
     * 任务模版名称
     */
    @NotBlank(message = PlatformCodeConstants.TASK_TEMPLATE_NAME_CANNOT_NULL)
    @ApiModelProperty(value = "任务模版名称",required = true)
    private String taskTemplateName;

    /**
     * 任务模版图标
     */
    @NotBlank(message = PlatformCodeConstants.TASK_TEMPLATE_ICON_CANNOT_NULL)
    @ApiModelProperty(value = "任务模版图标",required = true)
    private String taskTemplateIcon;

    /**
     * 任务类型
     */
    @NotBlank(message = PlatformCodeConstants.TASK_TYPE_ID_CANNOT_NULL)
    @ApiModelProperty(value = "任务类型Id",required = true)
    private String taskTypeId;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 创建者user_id
     */
    @NotBlank(message = PlatformCodeConstants.CREATE_USER_ID_CANNOR_NULL)
    @ApiModelProperty(value = "创建人userId",required = true,hidden = true)
    private String createBy;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 更新者user_id
     */
    private String updateBy;
}
