package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.List;

/**
 * @author: fpc
 * @data: 2019/11/20 15:54
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class TaskOperationQueryDTO implements Serializable {


    @NotBlank(message = PlatformCodeConstants.TASK_TEMPLATE_ID_CANNOT_NULL)
    @ApiModelProperty(value = "任务模版Id",required = true)
    private String taskTemplateId;


    @NotBlank(message = PlatformCodeConstants.TENANT_ID_NOT_NULL)
    @ApiModelProperty(value = "租户号",required = true)
    private String tenantId;

    /**
     * 权限任务操作id 1-发布临时任务 2-查询他人任务 3-分配他人任务 4-升级他人任务 5-分享他人任务 6-标签修改删除 7-内容修改 8-执行任务 9-特殊任务执行
     * 10-抢单 11-反馈他人任务 12-发布固定任务 13-执行固定任务 14-查询固定任务 15-发布巡视任务 16-查询巡视任务 17-执行巡视任务
     */
    @ApiModelProperty(value = "权限任务操作Id")
    private String permissionTaskOperationId;

    /**
     * 主语岗位Id
     */
    @NotBlank(message = PlatformCodeConstants.POSITION_ID_CANNOT_NULL)
    @ApiModelProperty(value = "主语岗位集合",required = true)
    private List<String> permissionSubjectPositionIdList;

    /**
     * 宾语岗位Id
     */
    @NotBlank(message = PlatformCodeConstants.OBJECT_POSITION_ID_CANNOT_NULL)
    @ApiModelProperty(value = "宾语岗位Id",required = true)
    private String permissionObjectPositionId;

    /**
     * 任务id
     */
    @NotBlank(message = PlatformCodeConstants.TASK_ID_CANNOT_NULL)
    @ApiModelProperty(value = "任务Id",required = true)
    private String taskId;

    /**
     * 用户id
     */
    @NotBlank(message = PlatformCodeConstants.USER_ID_CANNOT_BE_EMPTY)
    @ApiModelProperty(value = "用户userId",required = true)
    private String userId;

    /**
     * 任务工单Id
     */
    @NotBlank(message = PlatformCodeConstants.TASK_WORKSHEET_ID_CANNOT_NULL)
    @ApiModelProperty(value = "任务工单Id",required = true)
    private String taskWorksheetId;

}
