package com.ifourthwall.dbm.task.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author: fpc
 * @data: 2019/10/31 11:20
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class TaskOperateDTO implements Serializable {
    /**
     * 任务id
     */
    @NotBlank(message = PlatformCodeConstants.TASK_ID_CANNOT_NULL)
    private String taskId;

    /**
     * 是否有效  0 - 生效 1 - 未生效 2 - 删除
     */
    @NotBlank(message = PlatformCodeConstants.TASK_OPERATE_TYPE_CANNOT_NULL)
    private String valid;

    /**
     * 租户Id
     */
    @NotBlank(message = PlatformCodeConstants.TENANT_ID_NOT_NULL)
    private String tenantId;

    /**
     * 项目Id
     */
    @NotBlank(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;


    @NotBlank(message = PlatformCodeConstants.OPERATOR_ID_CANNOT_NULL)
    private String updateBy;

    /**
     * 更新时间
     */
    private Date updateTime;

    @NotEmpty(message = PlatformCodeConstants.POSITION_ID_CANNOT_NULL)
    private List<String> permissionSubjectPositionIdList;
}
